; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - Chapter Data: Intro Screen
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes
;
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Colors               include color.asm           ; Colour RAM Address / Colours
;
Game                    include inc\BH_Game.asm     ; Game Variables
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetA
; -------------------------------------------------------------------------------------------------------------- ;
Screen_Graphics         set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Screen_BayShore_Row01   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_BayShore_Row02   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_BayShore_Row03   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_BayShore_Row04   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_BayShore_Row05   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_BayShore_Row06   dc.b $02, $03, $04, $05, $06, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $09, $0a, $1e, $1f, $20, $86 ; 
Screen_BayShore_Row07   dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $21, $22, $23, $24, $25, $26, $27, $86 ; 
Screen_BayShore_Row08   dc.b $0b, $0c, $0d, $0e, $0f, $10, $11, $12, $13, $0b, $0c, $0d, $0e, $0f, $10, $11, $12, $13, $0b, $0c, $0d, $0e, $0f, $10, $11, $12, $13, $0b, $0c, $0d, $41, $28, $29, $2a, $2b, $00, $00, $2d, $2e, $86 ; 
Screen_BayShore_Row09   dc.b $14, $15, $16, $17, $18, $19, $1a, $1b, $1c, $14, $15, $16, $17, $18, $19, $1a, $1b, $1c, $14, $15, $16, $17, $18, $19, $1a, $1b, $1c, $14, $15, $16, $40, $00, $00, $00, $00, $30, $2f, $86, $86, $86 ; 
Screen_BayShore_Row0a   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $33, $32, $31, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row0b   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $35, $34, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row0c   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $36, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row0d   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $37, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row0e   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $38, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row0f   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $39, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row10   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $3a, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row11   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $3b, $3c, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row12   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $3d, $3e, $3f, $86, $86, $86, $86, $86 ; 
Screen_BayShore_Row13   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $42, $43, $86, $86, $86 ; 
Screen_BayShore_Row14   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $44, $45, $86, $86, $86 ; 
                        
Screen_Status_Text      set * ; 
                        include inc\BH_StatusTexts.asm ; default texts
Screen_Status_Text_End  set * ; 
; -------------------------------------------------------------------------------------------------------------- ;
Status_BayShore_FrameLe = *                         ; hbu011. - only 38 columns available 
                        * = Status_Text_Row01 + $00 ; 
                        dc.b $76, $74               ; 
                        * = Status_Text_Row02 + $00 ; 
                        dc.b $76, $74               ; 
                        * = Status_Text_Row03 + $00 ; 
                        dc.b $76, $74               ; 
                        * = Status_Text_Row04 + $00 ; 
                        dc.b $76, $fc               ; 
                        * = Status_Text_Row05 + $01 ; 
                        dc.b $a0, $fc               ; 
Status_BayShore_FrameRi = *                         ; .hbu011.
                        * = Status_Text_Row01 + $26 ; 
                        dc.b $76                    ; 
                        * = Status_Text_Row02 + $26 ; 
                        dc.b $76                    ; 
                        * = Status_Text_Row03 + $26 ; 
                        dc.b $76                    ; 
                        * = Status_Text_Row04 + $26 ; 
                        dc.b $fe                    ; 
                        * = Status_Text_Row05 + $25 ; 
                        dc.b $fe, $a0               ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Text_Row01 + BH_Scrn_Stat_LeTxt - $03] ; 
Screen_Status_Header    set *
                        dc.b "D" - $40 ; .hbu011.
                        dc.b " "       ; 
                        dc.b "D" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "Y" - $40 ; 
                        dc.b " "       ; 
                        dc.b "L" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "N" - $40 ; 
                        dc.b "D" - $40 ; 
                        dc.b "I" - $40 ; 
                        dc.b "N" - $40 ; 
                        dc.b "G" - $40 ; 
                        dc.b "S" - $40 ; 
                        * = Status_Text_Row03 + BH_Scrn_Stat_RiTxt ; 
Status_BayShore_Tanks   = *
                        dc.b "T" - $40 ; .hbu011.
                        dc.b "A" - $40 ; 
                        dc.b "N" - $40 ; 
                        dc.b "K" - $40 ; 
                        dc.b "S" - $40 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetB
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_Screen_Values   set  *      ; individual settings
Misc_BayShore_Raster    dc.b $cd    ; TabControlRaster
Misc_BayShore_St_Len    dc.b [Colors_Status_End - Colors_Status] ; copy status lenght
Misc_BayShore_St_Off_Lo dc.b <[Colors_Status - Colors_Screen]    ; copy status offset
Misc_BayShore_St_Off_Hi dc.b >[Colors_Status - Colors_Screen]    ; 
                        
Colors_Screen_Base      set  * ; 
                        dc.b YELLOW ; TabBackGroundColor
                        dc.b RED    ; BGCOL1
                        dc.b GREEN  ; BGCOL2
Colors_Screen           set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Colors_BayShore_Row01   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ;  
Colors_BayShore_Row02   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_BayShore_Row03   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ;  
Colors_BayShore_Row04   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_BayShore_Row05   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ;  
Colors_BayShore_Row06   dc.b $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $03, $03 ; 
Colors_BayShore_Row07   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $08, $08, $08, $08, $0e, $0e, $06, $06 ;  
Colors_BayShore_Row08   dc.b $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $06, $06, $06 ; 
Colors_BayShore_Row09   dc.b $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row0a   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_BayShore_Row0b   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row0c   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_BayShore_Row0d   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row0e   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_BayShore_Row0f   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row10   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_BayShore_Row11   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row12   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_BayShore_Row13   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06 ;  
Colors_BayShore_Row14   dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06 ; 
                        
Colors_Status           set  * ; 
                        include inc\BH_StatusColor.asm ; default colors
Colors_Status_End       set  * ; 
                        
;Colors_Status_Free     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; unused - 3 for base
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Color_Row03 + BH_Scrn_Stat_RiTxt] ; 
Colors_BayShore_Tanks   repeat 5      ; .hbu011.
                        dc.b WHITE    ; 
                        repend        ; 
                        * = [Status_Color_Row03 + BH_Scrn_Stat_RiVal] ; 
Colors_BayShore_TanksNo repeat 08     ; .hbu011.
                        dc.b BH_Scrn_Stat_ColorTanks ; 
                        repend        ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemCharSet
; -------------------------------------------------------------------------------------------------------------- ;
Chrset_BayShore         equ  *   ; 
                        
BayShoreChar00          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar01          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar02          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar03          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar04          dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar05          dc.b $bf ; #.######
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar06          dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar07          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar08          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar09          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        
BayShoreChar0a          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $eb ; ###.#.##
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar0b          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
BayShoreChar0c          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        
BayShoreChar0d          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        
BayShoreChar0e          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar0f          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $7e ; .######.
                        
BayShoreChar10          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
BayShoreChar11          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        
BayShoreChar12          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar13          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $76 ; .###.##.
                        
BayShoreChar14          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $30 ; ..##....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar15          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar16          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $33 ; ..##..##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar17          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar18          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar19          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1a          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1b          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1c          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1d          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1e          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar1f          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        
BayShoreChar20          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
BayShoreChar21          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $a7 ; #.#..###
                        dc.b $b7 ; #.##.###
                        dc.b $b7 ; #.##.###
                        
BayShoreChar22          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar23          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar24          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        
BayShoreChar25          dc.b $80 ; #.......
                        dc.b $83 ; #.....##
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar26          dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar27          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
BayShoreChar28          dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        
BayShoreChar29          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2a          dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2b          dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2c          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2d          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
BayShoreChar2e          dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar2f          dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar30          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
BayShoreChar31          dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar32          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar33          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $7f ; .#######
                        
BayShoreChar34          dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar35          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
BayShoreChar36          dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar37          dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar38          dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar39          dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
BayShoreChar3a          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
BayShoreChar3b          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3c          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $03 ; ......##
                        
BayShoreChar3d          dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3e          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3f          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
BayShoreChar40          dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar41          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar42          dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar43          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $7f ; .#######
                        
BayShoreChar44          dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar45          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
BayShoreChar46          dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar47          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        
BayShoreChar48          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar49          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        
BayShoreChar4a          dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayShoreChar4b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        
BayShoreChar4c          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
BayShoreChar4d          dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        
BayShoreChar4e          dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3e ; ..#####.
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        
BayShoreChar4f          dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar50          dc.b $70 ; .###....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
BayShoreChar51          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        
BayShoreChar52          dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar53          dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayShoreChar54          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
BayShoreChar55          dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar56          dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $78 ; .####...
                        dc.b $00 ; ........
                        
BayShoreChar57          dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        
BayShoreChar58          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
BayShoreChar59          dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5a          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        
BayShoreChar5c          dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        
BayShoreChar5d          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5e          dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5f          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        
BayShoreChar60          dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f4 ; ####.#..
                        dc.b $00 ; ........
                        
BayShoreChar61          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
BayShoreChar62          dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $2f ; ..#.####
                        dc.b $00 ; ........
                        
BayShoreChar63          dc.b $01 ; .......#
                        dc.b $05 ; .....#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $35 ; ..##.#.#
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
BayShoreChar64          dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $70 ; .###....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
BayShoreChar65          dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar66          dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar67          dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $7d ; .#####.#
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayShoreChar68          dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $7d ; .#####.#
                        
BayShoreChar69          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        
BayShoreChar6a          dc.b $55 ; .#.#.#.#
                        dc.b $57 ; .#.#.###
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayShoreChar6b          dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        
BayShoreChar6c          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $07 ; .....###
                        
BayShoreChar6d          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $74 ; .###.#..
                        dc.b $f0 ; ####....
                        
BayShoreChar6e          dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        
BayShoreChar6f          dc.b $fc ; ######.. .hbu. removed sand from water
                        dc.b $ff ; ######## .hbu.
                        dc.b $ff ; ######## .hbu.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayShoreChar70          dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar71          dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
BayShoreChar72          dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
BayShoreChar73          dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar74          dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayShoreChar75          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar76          dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
BayShoreChar77          dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar78          dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
;BayShoreChar79          dc.b $0a ; ....#.#.
;                        dc.b $05 ; .....#.#
;                        dc.b $05 ; .....#.#
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
                        
BayShoreChar79          dc.b $00 ; ........ adapted to center the cannon
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0a ; ....#.#.
                        dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar7a          dc.b $80 ; #....... foot of hill
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
BayShoreChar7b          dc.b $ff ; ########
                        dc.b $9b ; #..##.##
                        dc.b $cf ; ##..####
                        dc.b $bb ; #.###.##
                        dc.b $f3 ; ####..##
                        dc.b $f9 ; #####..#
                        dc.b $f7 ; ####.###
                        dc.b $ef ; ###.####
                        
BayShoreChar7c          dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c8 ; ##..#...
                        dc.b $9c ; #..###..
                        dc.b $3f ; ..######
                        
BayShoreChar7d          dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $70 ; .###....
                        dc.b $b8 ; #.###...
                        dc.b $ce ; ##..###.
                        
BayShoreChar7e          dc.b $ff ; ########
                        dc.b $50 ; .#.#....
                        dc.b $e5 ; ###..#.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $9f ; #..#####
                        dc.b $3f ; ..######
                        dc.b $f8 ; #####...
                        
BayShoreChar7f          dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayShoreChar80          dc.b $fa ; #####.#.
                        dc.b $eb ; ###.#.##
                        dc.b $ef ; ###.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $7d ; .#####.#
                        dc.b $fd ; ######.#
                        
BayShoreChar81          dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
BayShoreChar82          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayShoreChar83          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
BayShoreChar84          dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar85          dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar86          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar87           dc.b $ff ; ######## ; text
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayTextChar88           dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayTextChar89           dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar8a           dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar8b           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar8c           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayTextChar8d           dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar8e           dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
BayTextChar8f           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        
BayTextChar90           dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar91           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar92           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar93           dc.b $38 ; ..###...
                        dc.b $78 ; .####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $78 ; .####...
                        dc.b $38 ; ..###...
                        
BayTextChar94           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayTextChar95           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar96           dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar97           dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $87 ; #....###
                        dc.b $87 ; #....###
                        
BayTextChar98           dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        
BayTextChar99           dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $3c ; ..####..
                        
BayTextChar9a           dc.b $87 ; #....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayTextChar9b           dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
BayTextChar9c           dc.b $3c ; ..####..
                        dc.b $3c ; ..####..
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayTextChar9d           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar9e           dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $3e ; ..#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar9f           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
BayTextChara0           dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayTextChara1           dc.b $3c ; ..####..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChara2           dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
BayTextChara3           dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayTextChara4           dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChara5           dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
BayTextChara6           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3e ; ..#####.
                        dc.b $3c ; ..####..
                        
BayTextChara7           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChara8           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChara9           dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        
BayTextCharaa           dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        
BayTextCharab           dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
;BayBridgeCharac         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
                        
;BayBridgeCharad         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
                        
;BayBridgeCharae         dc.b $0a ; ....#.#.
;                        dc.b $05 ; .....#.#
;                        dc.b $05 ; .....#.#
;                        dc.b $03 ; ......##
;                        dc.b $03 ; ......##
;                        dc.b $0f ; ....####
;                        dc.b $0f ; ....####
;                        dc.b $0f ; ....####
                         
;BayBridgeCharaf         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
                         
;BayBridgeCharb0         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
;                        dc.b $ff ; ########
;                        dc.b $fc ; ######..
;                        dc.b $fc ; ######..
                         
;BayBridgeCharb1         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $c0 ; ##......
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
                        
BayBridgeCharac         dc.b $ff ; ######## adapted to center the cannon
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayBridgeCharad         dc.b $f0 ; ####.... adapted to center the cannon
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayBridgeCharae         dc.b $00 ; ........ adapted to center the cannon
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0a ; ....#.#.
                        dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
BayBridgeCharaf         dc.b $00 ; ........ adapted to center the cannon
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayBridgeCharb0         dc.b $00 ; ........ adapted to center the cannon
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayBridgeCharb1         dc.b $00 ; ........ adapted to center the cannon
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
BayBridgeCharb2         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
BayBridgeCharb3         dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
;BayBridgeCharb4         dc.b $aa ; #.#.#.#.
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $55 ; .#.#.#.#
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
;                        dc.b $00 ; ........
                        
BayBridgeCharb4         dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayBridgeCharb5         dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        
BayBridgeCharb6         dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
BayBridgeCharb7         dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $ff ; ########
                        
BayBridgeCharb8         dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
BayBridgeCharb9         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        
BayBridgeCharba         dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayBridgeCharbb         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        
BayBridgeCharbc         dc.b $fd ; ######.#
                        dc.b $f1 ; ####...#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $f1 ; ####...#
                        dc.b $ff ; ########
                        
BayBridgeCharbd         dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        
BayBridgeCharbe         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f5 ; ####.#.#
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $d5 ; ##.#.#.#
                        
BayBridgeCharbf         dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7e ; .######.
                        dc.b $7d ; .#####.#
                        
BayBridgeCharc0         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $c3 ; ##....##
                        
BayShoreCharc1          dc.b $f5 ; ####.#.# .hbu016.
                        dc.b $7d ; .#####.#
                        dc.b $5f ; .#.#####
                        dc.b $f7 ; ####.###
                        dc.b $77 ; .###.###
                        dc.b $fd ; ######.#
                        dc.b $dd ; ##.###.#
                        dc.b $7f ; .#####.#
                        
BayShoreCharc2          dc.b $5f ; .#.###.# .hbu016.
                        dc.b $fd ; ######.#
                        dc.b $dd ; ##.###.#
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $df ; ##.#####
                        dc.b $7d ; .#####.#
                        dc.b $f5 ; ####.#.#
                        
BayShoreCharc3          dc.b %01011111 ; c1 .hbu016.
                        dc.b %01111101 ; 
                        dc.b %11110101 ; 
                        dc.b %11011111 ; 
                        dc.b %11011101 ; 
                        dc.b %01111111 ; 
                        dc.b %01110111 ; 
                        dc.b %01111101 ; 
                        
BayShoreCharc4          dc.b %01110101 ; c2
                        dc.b %01111111 ; 
                        dc.b %01110111 ; 
                        dc.b %11011101 ; 
                        dc.b %11011101 ; 
                        dc.b %11110111 ; 
                        dc.b %01111101 ; 
                        dc.b %01011111 ; 
                        
BayShoreCharc5          dc.b %00000001 ; 7a
                        dc.b %00000011 ; 
                        dc.b %00001111 ; 
                        dc.b %00011111 ; 
                        dc.b %00111111 ; 
                        dc.b %00111111 ; 
                        dc.b %01111111 ; 
                        dc.b %11111111 ; 
                        
BayShoreCharc6          dc.b %11111111 ; 7b
                        dc.b %11011001 ; 
                        dc.b %11110011 ; 
                        dc.b %11011101 ; 
                        dc.b %11001111 ; 
                        dc.b %10011111 ; 
                        dc.b %11101111 ; 
                        dc.b %11110111 ; 
                        
BayShoreCharc7          dc.b %00000000 ; 7c
                        dc.b %00000011 ; 
                        dc.b %00000111 ; 
                        dc.b %00001111 ; 
                        dc.b %00000111 ; 
                        dc.b %00010011 ; 
                        dc.b %00111001 ; 
                        dc.b %11111100 ; 
                        
BayShoreCharc8          dc.b %00000001 ; 7d
                        dc.b %00000001 ; 
                        dc.b %00000011 ; 
                        dc.b %00000011 ; 
                        dc.b %00000111 ; 
                        dc.b %00001110 ; 
                        dc.b %00011101 ; 
                        dc.b %01110011 ; 
                        
BayShoreCharc9          dc.b %11111111 ; 7e
                        dc.b %00001010 ; 
                        dc.b %10100111 ; 
                        dc.b %10111111 ; 
                        dc.b %10111111 ; 
                        dc.b %11111001 ; 
                        dc.b %11111100 ; 
                        dc.b %00011111 ;   
                        
BayShoreCharca          dc.b %00000000 ; 7f
                        dc.b %00000001 ; 
                        dc.b %00000011 ; 
                        dc.b %00000011 ; 
                        dc.b %00000111 ; 
                        dc.b %00000111 ; 
                        dc.b %00001111 ; 
                        dc.b %00001111 ; 
                        
BayShoreCharcb          dc.b %01011111 ; 80
                        dc.b %11010111 ; 
                        dc.b %11110111 ; 
                        dc.b %11010101 ; 
                        dc.b %11111111 ; 
                        dc.b %00111111 ; 
                        dc.b %10111110 ; 
                        dc.b %10111111 ; 
                        
BayShoreCharcc          dc.b %00011111 ; 81
                        dc.b %00011111 ; 
                        dc.b %00011111 ; 
                        dc.b %00001111 ; 
                        dc.b %00001111 ; 
                        dc.b %00000111 ; 
                        dc.b %00000011 ; 
                        dc.b %00000011 ; 
                        
BayShoreCharcd          dc.b %11111111 ; 82
                        dc.b %11111111 ; 
                        dc.b %01111111 ; 
                        dc.b %00111111 ; 
                        dc.b %00011111 ; 
                        dc.b %00011111 ; 
                        dc.b %00001111 ; 
                        dc.b %00001111 ; 
                        
BayShoreCharce          dc.b %11111111 ; 83
                        dc.b %11111111 ; 
                        dc.b %11111111 ; 
                        dc.b %01111111 ; 
                        dc.b %00011111 ; 
                        dc.b %00001111 ; 
                        dc.b %00000011 ; 
                        dc.b %00000011 ; 
                        
BayShoreCharcf          dc.b %00000111 ; 84
                        dc.b %00000011 ; 
                        dc.b %00000001 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        
BayShoreChard0          dc.b %11111111 ; 85
                        dc.b %00111111 ; 
                        dc.b %00000111 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
                        dc.b %00000000 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemSprites
; -------------------------------------------------------------------------------------------------------------- ;
Sprite_BayShore         equ  *   ; 
SP_Store_Beach_00       dc.b %00000000, %00110000, %00000000 ; 5000 ; ..........##............
                        dc.b %00000000, %01110000, %00000000 ; 5003 ; .........###............
                        dc.b %00000000, %01111000, %00111000 ; 5006 ; .........####.....###...
                        dc.b %00110011, %10011100, %11111000 ; 5009 ; ..##..###..###..#####...
                        dc.b %01111111, %11111111, %11110000 ; 500c ; .###################....
                        dc.b %00110011, %11110111, %10100000 ; 500f ; ..##..######.####.#.....
                        dc.b %00011110, %11111100, %11100000 ; 5012 ; ...####.######..###.....
                        dc.b %00111111, %10011111, %11111100 ; 5015 ; ..#######..###########..
                        dc.b %01111111, %11111001, %10111110 ; 5018 ; .############..##.#####.
                        dc.b %11111001, %11111111, %11111000 ; 501b ; #####..##############...
                        dc.b %11011111, %11111110, %11100000 ; 501e ; ##.############.###.....
                        dc.b %00111111, %11001111, %11110000 ; 5021 ; ..########..########....
                        dc.b %00010011, %11111111, %11111000 ; 5024 ; ...#..###############...
                        dc.b %00011111, %11111110, %01111000 ; 5027 ; ...############..####...
                        dc.b %00111111, %10011111, %11000000 ; 502a ; ..#######..#######......
                        dc.b %01111011, %11111111, %11100000 ; 502d ; .####.#############.....
                        dc.b %01001011, %11110100, %11100000 ; 5030 ; .#..#.######.#..###.....
                        dc.b %00000011, %01000011, %10110000 ; 5033 ; ......##.#....###.##....
                        dc.b %00000111, %11000000, %11110000 ; 5036 ; .....#####......####....
                        dc.b %00000001, %10000000, %00110000 ; 5039 ; .......##.........##....
                        dc.b %00000000, %00000000, %00000000 ; 503c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_01       dc.b %00000000, %00000000, %00000000 ; 5040 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5043 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5046 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5049 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5052 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5055 ; ........................
                        dc.b %00000000, %00111111, %11000000 ; 5058 ; ..........########......
                        dc.b %00000000, %00111111, %11000000 ; 505b ; ..........########......
                        dc.b %11111111, %11010101, %01101000 ; 505e ; ##########.#.#.#.##.#...
                        dc.b %00001010, %10010101, %01101000 ; 5061 ; ....#.#.#..#.#.#.##.#...
                        dc.b %00001010, %10101010, %10101000 ; 5064 ; ....#.#.#.#.#.#.#.#.#...
                        dc.b %00001101, %11011101, %11011100 ; 5067 ; ....##.###.###.###.###..
                        dc.b %00000111, %11111111, %11110100 ; 506a ; .....###############.#..
                        dc.b %00001101, %11011101, %11011100 ; 506d ; ....##.###.###.###.###..
                        dc.b %00000000, %00000000, %00000000 ; 5070 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5073 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5076 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5079 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 507c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_02       dc.b %00000000, %00000000, %00000000 ; 5080 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5083 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5086 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5089 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5092 ; ........................
                        dc.b %00000000, %10100000, %00000000 ; 5095 ; ........#.#.............
                        dc.b %00000010, %10111111, %11000000 ; 5098 ; ......#.#.########......
                        dc.b %00001010, %10111111, %11000000 ; 509b ; ....#.#.#.########......
                        dc.b %11111111, %11010101, %01100000 ; 509e ; ##########.#.#.#.##.....
                        dc.b %00001111, %10010101, %01101000 ; 50a1 ; ....#####..#.#.#.##.#...
                        dc.b %00001111, %11101010, %10101100 ; 50a4 ; ....#######.#.#.#.#.##..
                        dc.b %00000011, %11111010, %10011100 ; 50a7 ; ......#######.#.#..###..
                        dc.b %00000000, %11111110, %01011100 ; 50aa ; ........#######..#.###..
                        dc.b %00000000, %00111111, %01010000 ; 50ad ; ..........######.#.#....
                        dc.b %00000000, %00001111, %01000000 ; 50b0 ; ............####.#......
                        dc.b %00000000, %00000011, %00000000 ; 50b3 ; ..............##........
                        dc.b %00000000, %00000000, %00000000 ; 50b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_03       dc.b %00000000, %00000000, %00000000 ; 50c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d5 ; ........................
                        dc.b %00000000, %00111111, %11000000 ; 50d8 ; ..........########......
                        dc.b %00000000, %00111111, %11100000 ; 50db ; ..........#########.....
                        dc.b %11111111, %11010101, %01101000 ; 50de ; ##########.#.#.#.##.#...
                        dc.b %00000000, %10010101, %01101100 ; 50e1 ; ........#..#.#.#.##.##..
                        dc.b %00000010, %10101010, %10111100 ; 50e4 ; ......#.#.#.#.#.#.####..
                        dc.b %00001110, %10101010, %11111100 ; 50e7 ; ....###.#.#.#.#.######..
                        dc.b %00001101, %10101011, %11110000 ; 50ea ; ....##.##.#.#.######....
                        dc.b %00001101, %01101111, %11000000 ; 50ed ; ....##.#.##.######......
                        dc.b %00000001, %01111111, %00000000 ; 50f0 ; .......#.#######........
                        dc.b %00000000, %01111100, %00000000 ; 50f3 ; .........#####..........
                        dc.b %00000000, %00110000, %00000000 ; 50f6 ; ..........##............
                        dc.b %00000000, %00000000, %00000000 ; 50f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_04       dc.b %00000000, %00000000, %00000000 ; 5100 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5103 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5106 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5109 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5112 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5115 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5118 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 511b ; ........................
                        dc.b %11111000, %00000000, %00000000 ; 511e ; #####...................
                        dc.b %00000000, %00000000, %00000000 ; 5121 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5124 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5127 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5130 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5133 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5136 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5139 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 513c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_05       dc.b %00000000, %00000000, %00000000 ; 5140 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5143 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5146 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5149 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5152 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5155 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5158 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 515b ; ........................
                        dc.b %00000000, %00000000, %00011111 ; 515e ; ...................#####
                        dc.b %00000000, %00000000, %00000000 ; 5161 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5164 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5167 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5170 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5173 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5176 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5179 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 517c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_06       dc.b %00000000, %00000000, %00000000 ; 5180 ; ........................    row_00
                        dc.b %00000000, %00000000, %00000000 ; 5183 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5186 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5189 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518f ; ........................
                        dc.b %00001010, %10100000, %00000000 ; 5192 ; ....#.#.#.#.............
                        dc.b %00101010, %10101000, %00000000 ; 5195 ; ..#.#.#.#.#.#...........
                        dc.b %10101010, %10101010, %00000000 ; 5198 ; #.#.#.#.#.#.#.#.........
                        dc.b %10101010, %10101010, %00000000 ; 519b ; #.#.#.#.#.#.#.#.........
                        dc.b %01101010, %10101001, %11111111 ; 519e ; .##.#.#.#.#.#..#########    row_10
                        dc.b %01011010, %10100101, %00000000 ; 51a1 ; .#.##.#.#.#..#.#........
                        dc.b %01010101, %01010101, %00000000 ; 51a4 ; .#.#.#.#.#.#.#.#........
                        dc.b %10010101, %01010110, %00000000 ; 51a7 ; #..#.#.#.#.#.##.........
                        dc.b %00100101, %01011000, %00000000 ; 51aa ; ..#..#.#.#.##...........
                        dc.b %00001010, %10100000, %00000000 ; 51ad ; ....#.#.#.#.............
                        dc.b %00000000, %00000000, %00000000 ; 51b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_07       dc.b %00000000, %00000000, %00000000 ; 51c0 ; ........................    row_00
                        dc.b %00000000, %00000000, %00000000 ; 51c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51d5 ; ........................
                        dc.b %00000010, %10101000, %00000000 ; 51d8 ; ......#.#.#.#...........
                        dc.b %00000010, %10101000, %00000000 ; 51db ; ......#.#.#.#...........
                        dc.b %00001110, %10101011, %11111100 ; 51de ; ....###.#.#.#.########..    row_10
                        dc.b %00000110, %10101001, %00000000 ; 51e1 ; .....##.#.#.#..#........
                        dc.b %00001101, %01010111, %00000000 ; 51e4 ; ....##.#.#.#.###........
                        dc.b %00000101, %01010101, %00000000 ; 51e7 ; .....#.#.#.#.#.#........
                        dc.b %00001110, %10101011, %00000000 ; 51ea ; ....###.#.#.#.##........
                        dc.b %00000110, %10101001, %00000000 ; 51ed ; .....##.#.#.#..#........
                        dc.b %00001101, %01010111, %00000000 ; 51f0 ; ....##.#.#.#.###........
                        dc.b %00001101, %01010111, %00000000 ; 51f3 ; ....##.#.#.#.###........
                        dc.b %00001100, %00000011, %00000000 ; 51f6 ; ....##........##........
                        dc.b %00000000, %00000000, %00000000 ; 51f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_08       dc.b %00000000, %00000000, %00000000 ; 5200 ; ........................    row_00
                        dc.b %00000000, %00000000, %00000000 ; 5203 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5206 ; ........................
                        dc.b %00000000, %10000000, %00000000 ; 5209 ; ........#...............
                        dc.b %00000000, %01100000, %00000000 ; 520c ; .........##.............
                        dc.b %00000011, %01011000, %00000000 ; 520f ; ......##.#.##...........
                        dc.b %00000011, %11010110, %00000000 ; 5212 ; ......####.#.##.........
                        dc.b %00110011, %00000101, %10000000 ; 5215 ; ..##..##.....#.##.......
                        dc.b %00111100, %00000001, %01100000 ; 5218 ; ..####.........#.##.....
                        dc.b %00110011, %11110000, %01100000 ; 521b ; ..##..######.....##.....
                        dc.b %00110011, %11111111, %11111111 ; 521e ; ..##..##################    row_10
                        dc.b %00110011, %00000000, %00100000 ; 5221 ; ..##..##..........#.....
                        dc.b %00001100, %11000000, %00100000 ; 5224 ; ....##..##........#.....
                        dc.b %00110000, %00110000, %00100000 ; 5227 ; ..##......##......#.....
                        dc.b %00000011, %00000000, %10100000 ; 522a ; ......##........#.#.....
                        dc.b %00000011, %11000010, %10100000 ; 522d ; ......####....#.#.#.....
                        dc.b %00000011, %00001010, %10000000 ; 5230 ; ......##....#.#.#.......
                        dc.b %00001111, %00101010, %00000000 ; 5233 ; ....####..#.#.#.........
                        dc.b %00000000, %10101000, %00000000 ; 5236 ; ........#.#.#...........
                        dc.b %00000000, %10100000, %00000000 ; 5239 ; ........#.#.............
                        dc.b %00000000, %10000000, %00000000 ; 523c ; ........#...............
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_09       dc.b %00000000, %00000000, %00000000 ; 5240 ; ........................    row_00
                        dc.b %00000000, %00000000, %00000000 ; 5243 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5246 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5249 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524f ; ........................
                        dc.b %00000000, %10000000, %00000000 ; 5252 ; ........#...............
                        dc.b %00000010, %10100000, %00000000 ; 5255 ; ......#.#.#.............
                        dc.b %00001010, %10101000, %00000000 ; 5258 ; ....#.#.#.#.#...........
                        dc.b %00101010, %10101010, %00000000 ; 525b ; ..#.#.#.#.#.#.#.........
                        dc.b %00011010, %10101001, %11111111 ; 525e ; ...##.#.#.#.#..#########    row_10
                        dc.b %00010110, %10100101, %00000000 ; 5261 ; ...#.##.#.#..#.#........
                        dc.b %00010101, %10010101, %00000000 ; 5264 ; ...#.#.##..#.#.#........
                        dc.b %00110101, %01010111, %00000000 ; 5267 ; ..##.#.#.#.#.###........
                        dc.b %00110001, %01010011, %00000000 ; 526a ; ..##...#.#.#..##........
                        dc.b %00110000, %01000011, %00000000 ; 526d ; ..##.....#....##........
                        dc.b %00110000, %11000011, %00000000 ; 5270 ; ..##....##....##........
                        dc.b %00110000, %11000011, %00000000 ; 5273 ; ..##....##....##........
                        dc.b %00000000, %11000000, %00000000 ; 5276 ; ........##..............
                        dc.b %00000000, %11000000, %00000000 ; 5279 ; ........##..............
                        dc.b %00000000, %11000000, %00000000 ; 527c ; ........##..............
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0a       dc.b %00000000, %00000000, %00000000 ; 5280 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5283 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5286 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5289 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5292 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5295 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5298 ; ##..##...##..##...##..##
                        dc.b %00011100, %01100110, %00110011 ; 529b ; ...###...##..##...##..##
                        dc.b %01110000, %01100110, %00110011 ; 529e ; .###.....##..##...##..##
                        dc.b %11000000, %01100110, %00110011 ; 52a1 ; ##.......##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 52a4 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 52a7 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 52aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0b       dc.b %00000000, %00000000, %00000000 ; 52c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52d2 ; ........................
                        dc.b %11001100, %01111110, %00111111 ; 52d5 ; ##..##...######...######
                        dc.b %11001100, %01100110, %00110011 ; 52d8 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 52db ; ##..##...##..##...##..##
                        dc.b %11111100, %01100110, %00110011 ; 52de ; ######...##..##...##..##
                        dc.b %00001100, %01100110, %00110011 ; 52e1 ; ....##...##..##...##..##
                        dc.b %00001100, %01100110, %00110011 ; 52e4 ; ....##...##..##...##..##
                        dc.b %00001100, %01111110, %00111111 ; 52e7 ; ....##...######...######
                        dc.b %00000000, %00000000, %00000000 ; 52ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0c       dc.b %00000000, %00000000, %00000000 ; 5300 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5303 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5306 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5309 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5312 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5315 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5318 ; ##..##...##..##...##..##
                        dc.b %11000000, %01100110, %00110011 ; 531b ; ##.......##..##...##..##
                        dc.b %11111100, %01100110, %00110011 ; 531e ; ######...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5321 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5324 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 5327 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 532a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 532d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5330 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5333 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5336 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5339 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 533c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0d       dc.b %00000000, %00000000, %00000000 ; 5340 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5343 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5346 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5349 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5352 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5355 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5358 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 535b ; ##..##...##..##...##..##
                        dc.b %01111000, %01100110, %00110011 ; 535e ; .####....##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5361 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5364 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 5367 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 536a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 536d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5370 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5373 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5376 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5379 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 537c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0e       dc.b %11000000, %00000000, %00000000 ; 5380 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5383 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5386 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5389 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 538c ; ##......................
                        dc.b %00001111, %11000000, %00000000 ; 538f ; ....######..............
                        dc.b %00001100, %11000000, %00000000 ; 5392 ; ....##..##..............
                        dc.b %00001100, %11000000, %00000000 ; 5395 ; ....##..##..............
                        dc.b %00001100, %11000000, %00000000 ; 5398 ; ....##..##..............
                        dc.b %00001111, %11000000, %00000000 ; 539b ; ....######..............
                        dc.b %00000000, %00011111, %10000000 ; 539e ; ...........######.......
                        dc.b %00000000, %00011001, %10000000 ; 53a1 ; ...........##..##.......
                        dc.b %00000000, %00011001, %10000000 ; 53a4 ; ...........##..##.......
                        dc.b %00000000, %00011001, %10000000 ; 53a7 ; ...........##..##.......
                        dc.b %00000000, %00011111, %10000000 ; 53aa ; ...........######.......
                        dc.b %00000000, %00000000, %00111111 ; 53ad ; ..................######
                        dc.b %00000000, %00000000, %00110011 ; 53b0 ; ..................##..##
                        dc.b %00000000, %00000000, %00110011 ; 53b3 ; ..................##..##
                        dc.b %00000000, %00000000, %00110011 ; 53b6 ; ..................##..##
                        dc.b %00000000, %00000000, %00111111 ; 53b9 ; ..................######
                        dc.b %00000000, %00000000, %00000000 ; 53bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_0f       dc.b %00000000, %00110000, %00000000 ; 53c0 ; ..........##............ - .hbu004.
                        dc.b %00000000, %01000000, %00000000 ; 53c3 ; .........#..............
                        dc.b %00000000, %01101000, %00011000 ; 53c6 ; .........##.#......##...
                        dc.b %00110011, %10000100, %01001000 ; 53c9 ; ..##..###....#...#..#...
                        dc.b %01101100, %01101011, %01110000 ; 53cc ; .##.##...##.#.##.###....
                        dc.b %00010011, %00100101, %00100000 ; 53cf ; ...#..##..#..#.#..#.....
                        dc.b %00001010, %01101000, %10000000 ; 53d2 ; ....#.#..##.#...#.......
                        dc.b %00110001, %00011010, %11010100 ; 53d5 ; ..##...#...##.#.##.#.#..
                        dc.b %01001110, %01100001, %00101100 ; 53d8 ; .#..###..##....#..#.##..
                        dc.b %01011000, %10010101, %11011000 ; 53db ; .#.##...#..#.#.###.##...
                        dc.b %10000010, %10100010, %10100000 ; 53de ; #.....#.#.#...#.#.#.....
                        dc.b %00101101, %01001101, %00110000 ; 53e1 ; ..#.##.#.#..##.#..##....
                        dc.b %00010001, %00100100, %11011000 ; 53e4 ; ...#...#..#..#..##.##...
                        dc.b %00001110, %10110010, %01101000 ; 53e7 ; ....###.#.##..#..##.#...
                        dc.b %00101001, %00011011, %01000000 ; 53ea ; ..#.#..#...##.##.#......
                        dc.b %01110011, %01101001, %10100000 ; 53ed ; .###..##.##.#..##.#.....
                        dc.b %00001000, %00010100, %11100000 ; 53f0 ; ....#......#.#..###.....
                        dc.b %00000010, %01000010, %10110000 ; 53f3 ; ......#..#....#.#.##....
                        dc.b %00000110, %10000000, %11000000 ; 53f6 ; .....##.#.......##......
                        dc.b %00000001, %00000000, %00110000 ; 53f9 ; .......#..........##....
                        dc.b %00000000, %00000000, %00000000 ; 53fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Beach_10       dc.b %00000000, %00000000, %00000000 ; 5400 ; ........................ - .hbu004.
                        dc.b %00000000, %00000000, %00000000 ; 5403 ; ........................
                        dc.b %00000000, %01000000, %00010000 ; 5406 ; .........#.........#....
                        dc.b %00110000, %10000100, %00001000 ; 5409 ; ..##....#....#......#...
                        dc.b %00001100, %01000011, %01000000 ; 540c ; ....##...#....##.#......
                        dc.b %00000010, %00000000, %00100000 ; 540f ; ......#...........#.....
                        dc.b %00000010, %00101000, %00000000 ; 5412 ; ......#...#.#...........
                        dc.b %00100000, %00011010, %01000100 ; 5415 ; ..#........##.#..#...#..
                        dc.b %00001000, %01000001, %00001100 ; 5418 ; ....#....#.....#....##..
                        dc.b %00011000, %10000001, %10000000 ; 541b ; ...##...#......##.......
                        dc.b %00000010, %00000010, %00000000 ; 541e ; ......#.......#.........
                        dc.b %00000101, %00001000, %00100000 ; 5421 ; .....#.#....#.....#.....
                        dc.b %00000001, %00000100, %11000000 ; 5424 ; .......#.....#..##......
                        dc.b %00000100, %10000010, %01001000 ; 5427 ; .....#..#.....#..#..#...
                        dc.b %00101000, %00000011, %00000000 ; 542a ; ..#.#.........##........
                        dc.b %01010000, %01100001, %00000000 ; 542d ; .#.#.....##....#........
                        dc.b %00000000, %00010000, %01000000 ; 5430 ; ...........#.....#......
                        dc.b %00000010, %00000000, %10100000 ; 5433 ; ......#.........#.#.....
                        dc.b %00000110, %00000000, %00000000 ; 5436 ; .....##.................
                        dc.b %00000000, %00000000, %00110000 ; 5439 ; ..................##....
                        dc.b %00000000, %00000000, %00000000 ; 543c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteBasePtr           set (BH_MemSprites - BH_MemVicGfx) / BH_SpriteDataLen
; -------------------------------------------------------------------------------------------------------------- ;
SP_Ptr_Beach_00         =   SpriteBasePtr  + $00 ; $40 ; explosion phase 1
SP_Ptr_Beach_01         =   SpriteBasePtr  + $01 ; $41 ; my tank move left
SP_Ptr_Beach_02         =   SpriteBasePtr  + $02 ; $42 ; my tank move up
SP_Ptr_Beach_03         =   SpriteBasePtr  + $03 ; $43 ; my tank move down
SP_Ptr_Beach_04         =   SpriteBasePtr  + $04 ; $44 ; shot left
SP_Ptr_Beach_05         =   SpriteBasePtr  + $05 ; $45 ; shot right
SP_Ptr_Beach_06         =   SpriteBasePtr  + $06 ; $46 ; cannon
SP_Ptr_Beach_07         =   SpriteBasePtr  + $07 ; $47 ; enemy tank
SP_Ptr_Beach_08         =   SpriteBasePtr  + $08 ; $48 ; machine gun
SP_Ptr_Beach_09         =   SpriteBasePtr  + $09 ; $49 ; turret
SP_Ptr_Beach_0a         =   SpriteBasePtr  + $0a ; $4a ; score  200
SP_Ptr_Beach_0b         =   SpriteBasePtr  + $0b ; $4b ; score  400
SP_Ptr_Beach_0c         =   SpriteBasePtr  + $0c ; $4c ; score  600
SP_Ptr_Beach_0d         =   SpriteBasePtr  + $0d ; $4d ; score  800
SP_Ptr_Beach_0e         =   SpriteBasePtr  + $0e ; $4e ; score 1000
SP_Ptr_Beach_0f         =   SpriteBasePtr  + $0f ; $4f ; explosion phase 2 - .hbu004.
SP_Ptr_Beach_10         =   SpriteBasePtr  + $10 ; $50 ; explosion phase 3 - .hbu004.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_00             set BH_SpriteStore + $00 * BH_SpriteDataLen ; $5000 - $40
SP_Store_01             set BH_SpriteStore + $01 * BH_SpriteDataLen ; $5040 - $41
SP_Store_02             set BH_SpriteStore + $02 * BH_SpriteDataLen ; $5080 - $42
SP_Store_03             set BH_SpriteStore + $03 * BH_SpriteDataLen ; $50c0 - $43
SP_Store_04             set BH_SpriteStore + $04 * BH_SpriteDataLen ; $5100 - $44
SP_Store_05             set BH_SpriteStore + $05 * BH_SpriteDataLen ; $5140 - $45
SP_Store_06             set BH_SpriteStore + $06 * BH_SpriteDataLen ; $5180 - $46
SP_Store_07             set BH_SpriteStore + $07 * BH_SpriteDataLen ; $51c0 - $47

SP_Store_08             set BH_SpriteStore + $08 * BH_SpriteDataLen ; $5200 - $48
SP_Store_09             set BH_SpriteStore + $09 * BH_SpriteDataLen ; $5240 - $49
SP_Store_0a             set BH_SpriteStore + $0a * BH_SpriteDataLen ; $5280 - $4a
SP_Store_0b             set BH_SpriteStore + $0b * BH_SpriteDataLen ; $52c0 - $4b
SP_Store_0c             set BH_SpriteStore + $0c * BH_SpriteDataLen ; $5300 - $4c
SP_Store_0d             set BH_SpriteStore + $0d * BH_SpriteDataLen ; $5340 - $4d
SP_Store_0e             set BH_SpriteStore + $0e * BH_SpriteDataLen ; $5380 - $4e
; -------------------------------------------------------------------------------------------------------------- ;
